/*
 * Decompiled with CFR 0.152.
 */
package no.statkart.launcher.client;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import no.statkart.launcher.client.InputDialog;
import no.statkart.launcher.client.Konfigurasjonsverdi;
import no.statkart.launcher.client.Parametre;
import no.statkart.launcher.client.StandardOppsett;
import no.statkart.launcher.client.Tjener;
import no.statkart.launcher.client.TjenerKontroll;

class Input {
    private final StandardOppsett standard;

    Input(StandardOppsett standard) {
        this.standard = standard;
    }

    Parametre innhentParametre(List<Parametre> tidligereInputParametre) {
        Parametre input;
        TjenerKontroll kontroll = new TjenerKontroll(this.standard);
        Optional<Object> feil = Optional.empty();
        if (!this.visHeap() && !this.visTjener() && !this.visBrukerPassord() && (feil = kontroll.utenBrukerPassord(tidligereInputParametre.get(0))).isEmpty()) {
            return tidligereInputParametre.get(0);
        }
        Path iconPath = this.standard.getRot().resolve("login.png");
        Path iconPath_test = this.standard.getRot().resolve("login_test.png");
        do {
            if ((input = new InputDialog().medTittel(this.inputTittel()).medMelding(this.melding(tidligereInputParametre.get(0).getTjener())).medIconPath(tidligereInputParametre.get(0).getTjener().equals(Tjener.ELIDA_PROD.getUrl()) ? iconPath : iconPath_test).visHeap(this.visHeap()).visTjener(this.visTjener()).visBrukerPassord(this.visBrukerPassord()).medTidligereInputParametre(tidligereInputParametre).medTidligereFeil(feil.orElse(null)).innhentInputParametre()) != null) continue;
            return null;
        } while ((feil = this.visBrukerPassord() ? kontroll.medBrukerPassord(input) : kontroll.utenBrukerPassord(input)).isPresent());
        return input;
    }

    private String melding(String tjener) {
        if (!this.visTjener() && tjener != null) {
            return Tjener.tittelForUrl(tjener);
        }
        return this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.INPUT_MESSAGE);
    }

    String inputTittel() {
        String tittel = this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.TITLE);
        String versjon = this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.VERSION);
        return versjon == null ? tittel + " (uversjonert)" : tittel + " " + versjon;
    }

    boolean visTjener() {
        return this.standard.getKonfigurasjon().is(Konfigurasjonsverdi.INPUT_SERVER) || this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.DEFAULT_SERVER) == null;
    }

    boolean visBrukerPassord() {
        return this.standard.getKonfigurasjon().is(Konfigurasjonsverdi.INPUT_CREDENTIALS);
    }

    boolean visHeap() {
        return this.standard.getKonfigurasjon().is(Konfigurasjonsverdi.INPUT_HEAP) || this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.DEFAULT_HEAP) == null;
    }
}

